/**********************************************************************************************

  Copyright (C) 2010 Hilscher Gesellschaft für Systemautomation mbH.
  This program can be used by everyone according the "industrialNETworX Public License INPL".
  The license can be downloaded under <http://www.industrialNETworX.com>.

***********************************************************************************************

   Last Modification:
    @version $Id: RPCTask_Functionlist.h 18912 2011-08-26 08:16:17Z Benjamin $

   Description:
     DCE-RPC includes.

   Changes:

     Date        Author        Description
     ----------------------------------------------------------------------------------
     2010-04-26  BM            Created
**************************************************************************************/
#ifndef __RPC_TASK_FUNCTIONLIST_H
#define __RPC_TASK_FUNCTIONLIST_H


/**
 * @defgroup dcerpc_task_startup DCERPC Startup Services
 *
 * @brief The following Prototypes shall be used to start the DCERPC
 *        task from rcX config.c file
 * @{
 */

TLR_RESULT
TaskExit_RPCTASK
(
 TLR_VOID FAR* pvRsc
);

TLR_RESULT
TaskLeave_RPCTASK
(
 TLR_VOID FAR* pvRsc,
 TLR_VOID FAR* pvLve
);

TLR_RESULT
TaskEnter_RPCTASK
(
 TLR_VOID FAR* pvInit
);


/**
 * version of task startup parameter */
#define RPC_TASK_STARTUP_PARAM_VERSION1 (1)
#define RPC_TASK_STARTUP_PARAM_VERSION2 (2)
#define RPC_TASK_STARTUP_PARAM_VERSION3 (3)
#define RPC_TASK_STARTUP_PARAM_VERSION4 (4)


/**
 * @brief Default Endpointmapper Port
 */
#define DCERPC_DEFAULT_ENDPOINTMAPPER_PORT  (135)
/* Note: if RPC is used inside a Profinet device this default port shall not be used */
/*       use 0x8894 instead! */

/**
 * @brief Task startup Parameters
 *
 * The structure represent a set of the startup parameter, which can be defined
 * or have to be defined to configure the task.
 */
typedef struct RPC_TASK_STARTUPPARAMETER_V4_Ttag    /* task startup parameter */
{
  TLR_UINT32    ulTaskIdentifier;
  TLR_UINT32    ulParamVersion;

  /** EDD name
   *
   * The member defines the name of Ethernet device driver, which
   * handles the access to an Ethernet port.
   */
  TLR_STR*      pszEddName;
  /** EDD instance
   *
   * The member defines the instance of the Ethernet device driver.
   */
  TLR_UINT32    ulEddInstance;

  /** EndpointMapper Port */
  TLR_UINT16    usEndpointMapperPort;
} RPC_TASK_STARTUPPARAMETER_V4_T;

/** @} */


/*************************************************************************************/
#endif /* #ifndef __RPC_TASK_FUNCTIONLIST_H */
